<?xml version='1.0'?>
<!-- Phonebook.xsl - Stylesheet for V60Backup phonebooks -->
<!-- Version 1.2 -->
<!-- Hugh Sparks, June 16, 2004 -->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:my="http://www.csparks.com/MotorolaPhonebook1">

<xsl:output method="html"/>

<xsl:template match="my:phonebook">
	<html>
	<head>
		<title><xsl:value-of select="@name"/></title>
		
		<style type="text/css">
			body
			{       font-family: sans-serif ;
				background-color: #CCCCCC ;
			}
			h2
			{	color: #00007F;
			}
			table
			{	border-width: 1px ;
				border-style: outset ;
			}
			th
			{	text-align: left;
				color: #00007F;
				border-width: 1px ;
				border-style: inset ;
				padding: 2 ;
			}
			td
			{	text-align: left;
				border-width: 1px ;
				border-style: inset ;
				padding: 2 ;
			}
		</style>
	</head>
	<body>
		<h2>Phonebook</h2>
		<table>
		<tr><th>Name</th><th>Type</th><th>Number</th></tr>
		<xsl:for-each select="my:entry">
			<xsl:sort select="@name"/>
			<xsl:call-template name="entry"/>
		</xsl:for-each>
		</table>
	</body>
	</html>
</xsl:template>

<xsl:template name="entry">
	<tr>
		<th><xsl:value-of select="@name"/></th>
		<td><xsl:value-of select="@type"/></td>
		<xsl:choose>
		<xsl:when test="@type='Email'">
			<td><xsl:value-of select="@value"/></td>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="area" select="substring(@value,1,3)"/>
			<xsl:variable name="pref" select="substring(@value,4,3)"/>
			<xsl:variable name="post" select="substring(@value,7,4)"/>
			<td>(<xsl:value-of select="$area"/>) <xsl:value-of select="$pref"/>-<xsl:value-of select="$post"/></td>
		</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>

</xsl:stylesheet>